
        <?php include 'include/navbar.php';?>
        <?php include 'include/sidebar.php';?>
     
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        <h1 class="mt-4">Dashboard</h1>
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item active">Add Sub Visa </li>
                        </ol>

                        <div class=" mt-4">
<?php

if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM sub_visa_types WHERE id = $id");
    header("Location: add-sub-visa-type.php");
    exit();
}

// Insert sub visa type
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $visa_type_id = intval($_POST['visa_type_id']);
    $sub_visa_type = trim($_POST['sub_visa_type']);

    if ($visa_type_id && !empty($sub_visa_type)) {
        $stmt = $conn->prepare("INSERT INTO sub_visa_types (visa_type_id, sub_visa_type) VALUES (?, ?)");
        $stmt->bind_param("is", $visa_type_id, $sub_visa_type);
        $stmt->execute();
    }
}

// Fetch all visa types
$visa_types = $conn->query("SELECT * FROM visa_types");

// Fetch all sub visa types with join
$sub_visa_list = $conn->query("SELECT sub_visa_types.*, visa_types.visa_type 
                               FROM sub_visa_types 
                               JOIN visa_types ON sub_visa_types.visa_type_id = visa_types.id");
?>
  <form method="POST" class="mb-4">
    <div class="mb-3">
      <label class="form-label">Visa Type</label>
      <select name="visa_type_id" class="form-select" required>
        <option value="">Select Visa Type</option>
        <?php while ($row = $visa_types->fetch_assoc()) { ?>
          <option value="<?= $row['id'] ?>"><?= htmlspecialchars($row['visa_type']) ?></option>
        <?php } ?>
      </select>
    </div>
    <div class="mb-3">
      <label class="form-label">Sub Visa Type</label>
      <input type="text" name="sub_visa_type" class="form-control" placeholder="Enter Sub Visa Type" required>
    </div>
    <button type="submit" class="btn btn-primary">Add Sub Visa Type</button>
  </form>

<h3>All Sub Visa Types</h3>
  <table class="table table-bordered">
    <thead>
      <tr>
        <th>ID</th>
        <th>Visa Type</th>
        <th>Sub Visa Type</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($row = $sub_visa_list->fetch_assoc()) { ?>
        <tr>
          <td><?= $row['id'] ?></td>
          <td><?= htmlspecialchars($row['visa_type']) ?></td>
          <td><?= htmlspecialchars($row['sub_visa_type']) ?></td>
          <td><a href="?delete=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this sub visa type?')">Delete</a></td>
        </tr>
      <?php } ?>
    </tbody>
  </table>

                    </div>
                </main>
                <?php include "include/footer.php";?>
            </div>
        </div>
<!-- JS TextEditor -->
<script src="//cdn.ckeditor.com/4.13.1/standard/ckeditor.js"></script>
         <script>
        CKEDITOR.replace('arContent');
    </script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
        <script src="assets/demo/chart-area-demo.js"></script>
        <script src="assets/demo/chart-bar-demo.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/simple-datatables@latest" crossorigin="anonymous"></script>
        <script src="js/datatables-simple-demo.js"></script>
    </body>
</html>
