<?php include 'include/navbar.php'; ?>
<?php include 'include/sidebar.php'; ?>

<?php
// Get Visa ID from URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<script>alert('Visa ID missing'); window.location.href='visas-list.php';</script>";
    exit;
}

$visa_id = $_GET['id'];

// Fetch existing visa
$visa_result = mysqli_query($conn, "SELECT * FROM visas WHERE id='$visa_id'");
if (mysqli_num_rows($visa_result) == 0) {
    echo "<script>alert('Visa not found'); window.location.href='visas-list.php';</script>";
    exit;
}

$visa = mysqli_fetch_assoc($visa_result);

// Fetch countries
$countries = mysqli_query($conn, "SELECT * FROM countries ORDER BY country_name ASC");

// Handle update
if (isset($_POST['update'])) {
    $title = $_POST['title'];
    $short_detail = $_POST['short_detail'];
    $full_detail = $_POST['full_detail'];
    $country_id = $_POST['country_id'];
    $apply_link = $_POST['apply_link'];
    $visa_type = $_POST['visa_type'];
    $sub_visa_type = $_POST['sub_visa_type'];

    $update = mysqli_query($conn, "UPDATE visas SET 
        title = '$title',
        short_detail = '$short_detail',
        full_detail = '$full_detail',
        country_id = '$country_id',
        apply_link = '$apply_link',
        visa_type = '$visa_type',
        sub_visa_type = '$sub_visa_type'
        WHERE id = '$visa_id'");

    if ($update) {
        echo "<script>alert('Visa updated successfully'); window.location.href='manage-visa.php';</script>";
    } else {
        echo "<script>alert('Error updating visa');</script>";
    }
}

?>
<?php
// DB connection
$visa_types = $conn->query("SELECT * FROM visa_types");
?>
<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid px-4">
            <h1 class="mt-4">Dashboard</h1>
            <ol class="breadcrumb mb-4">
                <li class="breadcrumb-item active">Edit Visa</li>
            </ol>

            <div class="mt-4">
               <form method="POST">
    <input type="text" name="title" class="form-control mb-3" placeholder="Visa Title"
           value="<?= htmlspecialchars($visa['title']); ?>" required>

    <input type="text" name="apply_link" class="form-control mb-3" placeholder="Apply Now Link"
           value="<?= htmlspecialchars($visa['apply_link']); ?>" required>

    <textarea name="short_detail" class="form-control mb-3" placeholder="Short Detail" required><?= htmlspecialchars($visa['short_detail']); ?></textarea>

    <select name="country_id" class="form-control mb-3" required>
        <option value="">Select Country</option>
        <?php while ($row = mysqli_fetch_assoc($countries)): ?>
            <option value="<?= $row['id']; ?>" <?= $row['id'] == $visa['country_id'] ? 'selected' : ''; ?>>
                <?= $row['country_name']; ?>
            </option>
        <?php endwhile; ?>
    </select>

   

 <?php
// Existing selected values
$visa_type_id = $visa['visa_type'];
$sub_visa_type_id = $visa['sub_visa_type'];

// Get visa type name
$visa_type_name = '';
$sub_visa_type_name = '';

if ($visa_type_id) {
  $res = $conn->query("SELECT visa_type FROM visa_types WHERE id = $visa_type_id");
  if ($res && $res->num_rows > 0) {
    $visa_type_name = $res->fetch_assoc()['visa_type'];
  }
}

if ($sub_visa_type_id) {
  $res = $conn->query("SELECT sub_visa_type FROM sub_visa_types WHERE id = $sub_visa_type_id");
  if ($res && $res->num_rows > 0) {
    $sub_visa_type_name = $res->fetch_assoc()['sub_visa_type'];
  }
}

// Fetch all visa types (for dropdown)
$visa_types = $conn->query("SELECT * FROM visa_types");
?>

<!-- Visa Type -->
<div class="mb-3">
  <select name="visa_type" id="visa_type" class="form-select">
    <option value="<?= $visa_type_id ?>"><?= htmlspecialchars($visa_type_name) ?></option>
    <?php while($row = $visa_types->fetch_assoc()) { ?>
      <option value="<?= $row['id'] ?>"><?= htmlspecialchars($row['visa_type']) ?></option>
    <?php } ?>
  </select>
</div>

<!-- Sub Visa Type -->
<div class="mb-3">
  <select name="sub_visa_type" id="sub_visa_type" class="form-select">
    <option value="<?= $sub_visa_type_id ?>"><?= htmlspecialchars($sub_visa_type_name) ?></option>
  </select>
</div>



<script>
  $(document).ready(function(){
    $('#visa_type').on('change', function(){
      var visa_type_id = $(this).val();
      if(visa_type_id != ""){
        $.ajax({
          url: "get_sub_visa_types.php",
          type: "GET",
          data: { visa_type_id: visa_type_id },
          success: function(data){
            $('#sub_visa_type').html(data);
          }
        });
      } else {
        $('#sub_visa_type').html('<option value="">Select Sub Visa Type</option>');
      }
    });
  });
</script>


    <textarea name="full_detail" class="form-control mb-3" id="arContent" placeholder="Full Detail" required><?= htmlspecialchars($visa['full_detail']); ?></textarea>

    <button type="submit" name="update" class="btn btn-success">Update Visa</button>
</form>

            </div>
        </div>
    </main>
    <?php include "include/footer.php"; ?>
</div>

<!-- JS TextEditor -->
<script src="//cdn.ckeditor.com/4.13.1/standard/ckeditor.js"></script>
<script>CKEDITOR.replace('arContent');</script>


        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
        <script src="assets/demo/chart-area-demo.js"></script>
        <script src="assets/demo/chart-bar-demo.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/simple-datatables@latest" crossorigin="anonymous"></script>
        <script src="js/datatables-simple-demo.js"></script>
    </body>
</html>
