<?php include 'include/header.php';?>
<?php include 'include/navbar.php';?>
 <style>
     .job-card {
      border: 1px solid #ddd;
      border-left: 5px solid #00796B;
      border-radius: 6px;
      padding: 20px;
      margin-bottom: 20px;
      background-color: #fff;
    }
    .btn-apply {
      background-color: #00796B;
      color: #fff;
    }
    .btn-apply:hover {
      background-color: #00796B;
    }
    .job-title {
      font-weight: 600;
      font-size: 1.2rem;
    }



.pagination .page-link {
    color: #00796B;
    border: 1px solid #00796B;
  }
  .pagination .page-link:hover {
    background-color: #00796B;
    color: #fff;
  }
  .pagination .active .page-link {
    background-color: #00796B;
    border-color: #00796B;
    color: #fff;
    box-shadow: none;
  }
  .border-primary{
    border-color: #00796B !important;
  }
  </style>
<div style="background-image:url('img/country-images.jpg'); background-size: cover; background-repeat: no-repeat;">
<header class="py-5 text-center" style="background-color:rgb(000, 000, 000,0.6);">
 <div class="container">
  <?php
  $heading = "Select Your Desired Visa";
  
  if (isset($_GET['country_id']) && is_numeric($_GET['country_id'])) {
      $country_id = (int)$_GET['country_id'];
      $country_query = mysqli_query($conn, "SELECT country_name FROM countries WHERE id = $country_id");

      if ($country_query && mysqli_num_rows($country_query) > 0) {
          $country = mysqli_fetch_assoc($country_query);
          $heading .= " – " . htmlspecialchars($country['country_name']);
      }
  }
  ?>

  <h1 class="text-white section-title"><?= $heading ?></h1>
  <p class="text-white">Explore visa options by country. Simple. Fast. Trusted by thousands globally.</p>
</div>

</header>
</div>


<div class="container py-5">
    <h1 class="text-center mb-4">Select Your Desired Visa</h1>

  <form method="GET" class="mb-4">
  <div class="row g-2">
    <div class="col-md-4 mt-2">
      <input type="text" name="keyword" class="form-control" placeholder="Search visa title..." value="<?= isset($_GET['keyword']) ? htmlspecialchars($_GET['keyword']) : '' ?>">
    </div>
    <div class="col-md-4 mt-2">
      <select name="country_id" class="form-control">
        <option value="">Choose Country</option>
        <?php
        $countries = mysqli_query($conn, "SELECT id, country_name FROM countries ORDER BY country_name ASC");
        while ($row = mysqli_fetch_assoc($countries)) {
            $selected = (isset($_GET['country_id']) && $_GET['country_id'] == $row['id']) ? 'selected' : '';
            echo "<option value=\"{$row['id']}\" $selected>{$row['country_name']}</option>";
        }
        ?>
      </select>
    </div>
    <div class="col-md-2 mt-2">
      <button type="submit" class="btn btn-apply w-100">Search</button>
    </div>
    <div class="col-md-2 mt-2">
      <a href="visas.php" class="btn btn-danger w-100">Reset</a>
    </div>
  </div>
</form>

  </div>

<section>
  <div class="container">
<?php


// Connect to DB if not already connected
// include('db_connection.php'); // Uncomment if needed

if (!isset($_GET['country_id']) || !is_numeric($_GET['country_id'])) {
    echo "<h2>Select a country to find visa</h2>";
    exit;
}

$country_id = (int)$_GET['country_id'];

// Fetch country
$country_query = mysqli_query($conn, "SELECT country_name FROM countries WHERE id = $country_id");

if (!$country_query || mysqli_num_rows($country_query) === 0) {
    echo "<h2>Select a country to find visa</h2>";
    exit;
}

$country = mysqli_fetch_assoc($country_query);

echo "<h2>{$country['country_name']} - All Visas</h2><div class='row g-4 mt-2'>";

// Fetch visas
$visa_query = mysqli_query($conn, "SELECT * FROM visas WHERE country_id = $country_id ORDER BY id DESC");

if (mysqli_num_rows($visa_query) === 0) {
    echo "<div class='col-12'><p>No visas found for this country.</p></div>";
}

while ($visa = mysqli_fetch_assoc($visa_query)) {
    echo "<div class='col-md-4'>
            <div class='card h-100 shadow-sm border-start border-4 border-primary'>
                <div class='card-body'>
                    <h5 class='card-title'>{$visa['title']}</h5>
                    <p class='card-text'>{$visa['short_detail']}</p>
                    <a href='visa-details.php?id={$visa['id']}' class='btn my-btn w-100'>Apply Now</a>
                </div>
            </div>
          </div>";
}
echo "</div>";
?>


  </div>
</section>


<br><br>


 <?php include 'include/footer.php';?>