<style>
.whatsapp-button {
  position: fixed;
  bottom: 20px;
  right: 20px;
  z-index: 1000;
  width: 60px;
  height: 60px;
  background-color: #25D366;
  border-radius: 50%;
  box-shadow: 0 4px 8px rgba(0,0,0,0.3);
  display: flex;
  justify-content: center;
  align-items: center;
  transition: transform 0.3s ease;
}

.whatsapp-button img {
  width: 30px;
  height: 30px;
}

.whatsapp-button:hover {
  transform: scale(1.1);
}




.social-icon:hover {
  transform: scale(1.1);
  text-decoration: none;
}


</style>
<!-- WhatsApp Button -->
<a href="https://wa.me/<?php echo preg_replace('/\D/', '', $info['whatsapp']); ?>" class="whatsapp-button" target="_blank" title="Chat with us on WhatsApp">
  <img src="https://img.icons8.com/color/48/000000/whatsapp--v1.png" alt="WhatsApp">
</a>

<footer class=" pt-5 pb-3 border-top">
  <div class="container">
    <div class="row">

      <!-- About Section -->
      <div class="col-md-4 mb-4">
  <a class="" href="/"><img  src="uploads/<?php echo $info['logo']; ?>" style="max-width: 200px;" ></a>
  <br>
        <p class="small text-white"><?php echo $info['home_banner_content']; ?></p>
      </div>

      <!-- Quick Links -->
      <div class="col-md-2 mb-4">
        <h6 class="fw-semibold">Quick Links</h6>
        <ul class="list-unstyled small">
          <li><a href="index.php" class="text-decoration-none text-white">Home</a></li>
          <li><a href="about.php" class="text-decoration-none text-white">About Us</a></li>
          <li><a href="blog.php" class="text-decoration-none text-white">Blogs</a></li>
          <li><a href="contact.php" class="text-decoration-none text-white">Contact</a></li>
        </ul>
      </div>

      <!-- Visa Categories -->
      <div class="col-md-3 mb-4">
        <h6 class="fw-semibold">Visa Categories</h6>
       <?php

// Fetch visa types
$visaQuery = mysqli_query($conn, "SELECT `id`, `visa_type` FROM `visa_types`");
?>

<ul class="list-unstyled small">
  <?php while ($visa = mysqli_fetch_assoc($visaQuery)): ?>
    <li>
      <a href="visas.php?visa_type=<?php echo $visa['id']; ?>" class="text-decoration-none text-white">
        <?php echo htmlspecialchars($visa['visa_type']); ?>
      </a>
    </li>
  <?php endwhile; ?>
</ul>

      </div>

      <!-- Contact -->
      <div class="col-md-3 mb-4">
        <h6 class="fw-semibold">Contact Us</h6>
        <p class="small text-white mb-1">Email: <?php echo $info['email']; ?></p>
        <p class="small text-white mb-1">Phone: <?php echo $info['phone']; ?></p>
        <?php
$result = mysqli_query($conn, "SELECT * FROM website_info LIMIT 1");
$data = mysqli_fetch_assoc($result);

// List of social platforms
$socials = [
  'facebook' => 'fab fa-facebook-f',
  'instagram' => 'fab fa-instagram',
  'twitter' => 'fab fa-twitter',
  'linkedin' => 'fab fa-linkedin-in',
  'youtube' => 'fab fa-youtube',
  'tiktok' => 'fab fa-tiktok',
  'pinterest' => 'fab fa-pinterest-p'
];
?>

<div class="">
  <div class="row justify-content-start">
    <?php foreach ($socials as $platform => $iconClass): ?>
      <?php if (!empty($data[$platform])): ?>
        <div class=" mb-3">
          <a href="<?php echo $data[$platform]; ?>" target="_blank" class="d-block social-icon bg-<?php echo $platform; ?> text-white rounded-circle p-3" title="<?php echo ucfirst($platform); ?>">
            <i class="<?php echo $iconClass; ?> fa-lg"></i>
          </a>
        </div>
      <?php endif; ?>
    <?php endforeach; ?>
  </div>
</div>

      </div>

    </div>

    <hr>
    <div class="text-center small text-white">
      © <?php echo date("Y"); ?> <?php echo $info['website_name']; ?>. All Rights Reserved. | <a href="privacy.php" class="text-white">Privacy Policy</a>
    </div>
  </div>
</footer>

  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<!-- jQuery + Popper + Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<!-- JS for Submenu Toggle -->
<script>
$(document).ready(function () {
  $('.dropdown-submenu > a').on("click", function (e) {
    e.preventDefault();
    e.stopPropagation();

    var $submenu = $(this).next('.dropdown-menu');

    // Close other open submenus
    $(this).closest('.dropdown-menu').find('.dropdown-submenu .dropdown-menu').hide();
    $(this).closest('.dropdown-menu').find('.dropdown-submenu').removeClass('show');

    // Toggle current submenu
    $submenu.toggle();
    $(this).parent().toggleClass('show');
  });
});
</script>


    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <!-- <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script> -->
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
</body>
</html>
