<?php include 'db.php';?>
<?php
$infoQuery = mysqli_query($conn, "SELECT * FROM website_info LIMIT 1");
$info = mysqli_fetch_assoc($infoQuery);
$website_name= $info['website_name']; 
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">


<link rel="icon" type="image/png" href="img/favicon.png">

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "<?php echo $website_name ?> ",
  "url": "<?php echo $domain?>",
  "logo": "<?php echo $domain?>/img/favicon.png"
}
</script>


    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">

     <link rel="stylesheet" type="text/css" href="css/style.css">
<!-- Favicon -->
<link rel="icon" type="image/png" href="img/favicon.png">

<link href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">


<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">



<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-XN581S2NXG"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-XN581S2NXG');
</script>




<?php
$page = basename($_SERVER['PHP_SELF']); // Get current page

switch ($page) {
  case 'index.php':
    $title = "$website_name  | Apply for Global Visas Online Easily";
    $description = "Apply for visas to UAE, Canada, UK, USA, and more with $website_name  – your trusted global visa application platform.";
    break;

  case 'visas.php':
    $title = "Visa Categories | $website_name  - Global Visa Options";
    $description = "Explore various visa types available on $website_name . Tourist, Work, Student visas for multiple countries worldwide.";
    break;

  case 'visa-details.php':
    $title = "Visa Details | $website_name  - Requirements & Info";
    $description = "Find detailed visa requirements, documents needed, and application process for your selected country on $website_name .";
    break;

  case 'apply.php':
    $title = "Apply Now | $website_name  - Global Visa Application Form";
    $description = "Apply for your global visa online through $website_name 's easy-to-use visa application form. Safe, Fast & Reliable.";
    break;

  case 'about.php':
    $title = "About $website_name  | Trusted Global Visa Platform";
    $description = "$website_name  is a one-stop visa solution helping users apply globally for visas to UAE, UK, Canada, and more.";
    break;

  case 'contact.php':
    $title = "Contact Us | $website_name  Support & Help";
    $description = "Get in touch with $website_name 's support team for assistance with your global visa application.";
    break;

  case 'blog.php':
    $title = "Visa Tips & News Blog | $website_name ";
    $description = "Read the latest visa updates, country immigration news, and travel guides on the $website_name  blog.";
    break;

  case 'blog-details.php':
    $title = "Blog Article | $website_name ";
    $description = "Detailed article about visa processes, requirements, and travel tips. Powered by $website_name .";
    break;

  case 'terms.php':
    $title = "Terms and Conditions | $website_name ";
    $description = "Review the terms and conditions for using $website_name  to apply for global visas online.";
    break;

  case 'privacy.php':
    $title = "Privacy Policy | $website_name ";
    $description = "Understand how $website_name  collects, uses, and protects your personal data when you apply for visas.";
    break;

  default:
    $title = "$website_name  | Global Visa Application Platform";
    $description = "Start your visa journey with $website_name  – a secure and reliable platform for global visa applications.";
}

    // Output meta tags
    echo "<title>$title</title>";
    echo "<meta name='description' content='$description'>";
?>



  </head>
  <body>