<?php include 'include/header.php';?>
<?php include 'include/navbar.php';?>

  <style>
    body {
      background: #f7f7f7;
    }
    .login-box {
      max-width: 400px;
      margin: 80px auto;
      padding: 30px;
      background: #fff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      border-radius: 10px;
    }
    .login-box h2 {
      margin-bottom: 25px;
    }
    .form-control:focus {
      box-shadow: none;
      border-color: #00796B;
    }
    .btn-warning {
      width: 100%;
    }
  </style>

<div class="login-box">

  <h2 class="text-center text-dark">Login to <?php echo $info['website_name']; ?></h2>
<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $recaptcha_response = $_POST['g-recaptcha-response'];

    $verify_response = file_get_contents(
        "https://www.google.com/recaptcha/api/siteverify?secret={$recaptcha_secret}&response={$recaptcha_response}"
    );
    $response_data = json_decode($verify_response);

    if (!$response_data->success) {
        echo "<p class=' btn-sm p-2 bg-danger text-white rounded text-center'>Captcha verification failed. Please try again.</p>";
    } else {
        // Proceed with login
        $email = mysqli_real_escape_string($conn, $_POST['email']);
        $password = $_POST['password'];

        $query = "SELECT * FROM users WHERE email = '$email'";
        $result = mysqli_query($conn, $query);

        if ($row = mysqli_fetch_assoc($result)) {
            if ($row['status'] == 0) {
                echo "<p class='btn-sm p-2 bg-danger text-white rounded text-center'>Please verify your email before logging in.</p>";
            } elseif (password_verify($password, $row['password'])) {
                $_SESSION['user_id'] = $row['id'];
                $_SESSION['user_name'] = $row['name'];
                echo "<p class='p-2 bg-success text-white rounded text-center'>Login successful</p>";
                header("Location: visas.php");
                exit;
            } else {
                echo "<p class='p-2 bg-danger text-white rounded text-center'>Incorrect password.</p>";
            }
        } else {
            echo "<p class='p-2 bg-danger text-white rounded text-center'>No user found with this email.</p>";
        }
    }
}
?>


  <form action="" method="POST">
    <div class="mb-3">
      <label for="email" class="form-label">Email Address</label>
      <input type="email" name="email" id="email" class="form-control" required placeholder="Enter email">
    </div>

    <div class="mb-3">
      <label for="password" class="form-label">Password</label>
      <input type="password" name="password" id="password" class="form-control" required placeholder="Enter password">
    </div>

 <div class="mb-3">
  <div class="g-recaptcha" data-sitekey="<?php echo $recaptcha_site;?>"></div>
</div>

    <button type="submit" class="btn my-btn btn-block">Login</button>
  </form>

  <p class="mt-3 text-center">
    Don't have an account? <a href="register.php" class="my-color">Register</a>
    <br> Or <a href="forget-password.php" class="my-color">Forget Password?</a>
  </p>
</div>














 <?php include 'include/footer.php';?>