<?php
include 'db.php';


// Get the verification code from the URL
if (isset($_GET['code'])) {
    $code = mysqli_real_escape_string($conn, $_GET['code']);

    // Check if the code exists
    $query = "SELECT * FROM users WHERE verification_code = '$code' AND status = 0";
    $result = mysqli_query($conn, $query);

    if (mysqli_num_rows($result) > 0) {
        // Update status to 1 (approved)
        $update = "UPDATE users SET status = 1 WHERE verification_code = '$code'";
        if (mysqli_query($conn, $update)) {
            $alertType = "success";
            $alertText = "Your email has been successfully verified!";
            $redirect = "login.php"; // Redirect to login page
        } else {
            $alertType = "error";
            $alertText = "Failed to update your status. Please try again.";
            $redirect = "register.php"; // Redirect to register page
        }
    } else {
        $alertType = "warning";
        $alertText = "Invalid or already verified code!";
        $redirect = "register.php";
    }
} else {
    $alertType = "error";
    $alertText = "No verification code provided!";
    $redirect = "register.php";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Verification</title>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
  <script>
    Swal.fire({
      icon: '<?= $alertType ?>',
      title: '<?= $alertText ?>',
      confirmButtonText: 'OK'
    }).then(() => {
      window.location.href = '<?= $redirect ?>';
    });
  </script>
</body>
</html>
