<?php include 'include/header.php';?>
<?php include 'include/navbar.php';?>
 <?php 
 If(!isset($_SESSION['user_name'])){
  header('location:login.php');
}
?>
 <style>
     .job-card {
      border: 1px solid #ddd;
      border-left: 5px solid #00796B;
      border-radius: 6px;
      padding: 20px;
      margin-bottom: 20px;
      background-color: #fff;
    }
    .btn-apply {
      background-color: #00796B;
      color: #fff;
    }
    .btn-apply:hover {
      background-color: #00796B;
    }
    .job-title {
      font-weight: 600;
      font-size: 1.2rem;
    }



.pagination .page-link {
    color: #00796B;
    border: 1px solid #00796B;
  }
  .pagination .page-link:hover {
    background-color: #00796B;
    color: #fff;
  }
  .pagination .active .page-link {
    background-color: #00796B;
    border-color: #00796B;
    color: #fff;
    box-shadow: none;
  }
  .border-primary{
    border-color: #00796B !important;
  }
  </style>
<div style="background-image:url('img/about-us.jpg'); background-size: cover; background-repeat: no-repeat;">
<header class="py-5 text-center" style="background-color:rgb(000, 000, 000,0.8);">
  <div class="container">
    <h1 class="text-white section-title">Visa Details</h1>
    <p class="text-white">Explore all the essential details and requirements for your visa application</p>
  </div>
</header>
</div>



<?php
// Check if 'id' is set and is a number
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "<p class='text-danger text-center mt-5'>Invalid Visa ID</p>";
    exit;
}

$id = (int) $_GET['id']; // cast to integer for safety


$query = mysqli_query($conn, "
    SELECT v.id, v.title, v.short_detail, v.full_detail, v.country_id, v.apply_link, v.created_at, v.visa_type,
           c.country_name
    FROM visas v
    JOIN countries c ON v.country_id = c.id
    WHERE v.id = $id
    LIMIT 1
");

if (!$query || mysqli_num_rows($query) == 0) {
    echo "<p class='text-center mt-5'>Visa not found.</p>";
    exit;
}

$visa = mysqli_fetch_assoc($query);




?>

<div class="container mt-5 mb-5">

    <!-- Visa Header -->
    <div class="visa-header mb-3 text-center">
        <h2 class="fw-bold"><?= htmlspecialchars($visa['title']) ?></h2>
        <small class="text-muted">Posted on <?= date('d M, Y', strtotime($visa['created_at'])) ?></small>
    </div>

    <!-- Visa Details Grid -->
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-4 text-muted mb-4 visa-details-grid">
        <div class="col d-flex align-items-center">
            <i class="fas fa-info-circle visa-info-icon me-2  mr-2"></i> <?= htmlspecialchars($visa['short_detail']) ?>
        </div>
        <div class="col d-flex align-items-center">
    <i class="fas fa-globe visa-info-icon me-2 mr-2"></i> <?= htmlspecialchars($visa['country_name']) ?>
</div>
        <div class="col d-flex align-items-center">
    <i class="fa-solid fa-note-sticky me-2 mr-2"></i> <?= htmlspecialchars($visa['visa_type']) ?>
</div>

    </div>

    <!-- Full Description -->
    <h3 class="fw-bold mb-3">Details</h3>
    <p><?= $visa['full_detail'] ?></p>

        <!-- Apply Button -->
  
 <!-- Visa Details Grid -->
<div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-4 text-muted mb-4 visa-details-grid">

    <!-- Option 1: Use Our Visa Service -->
    <div class="col d-flex align-items-center justify-content-center">
        <div class="text-center mt-4">
            <a href="apply.php?job_id=<?= $id ?>" class="btn my-btn">Use Our Visa Service</a>
        </div>
    </div>

    <!-- Option 2: Apply via Third Party -->
    <div class="col d-flex align-items-center justify-content-center">
        <div class="text-center mt-4">
            <a href="<?php echo $visa['apply_link']?>" target="_blank" class="btn my-btn">Apply via Third Party</a>
        </div>
    </div>

</div>



</div>

<style>
.visa-info-icon {
    font-size: 1.2rem;
    color: #00796B;
}
.visa-header a {
    text-decoration: underline;
    color: #00796B;
}
.visa-header a:hover {
    color: #00796B;
}
</style>




 <?php include 'include/footer.php';?>