<?php include 'include/header.php';?>
<?php include 'include/navbar.php';?>
 <style>
     .job-card {
      border: 1px solid #ddd;
      border-left: 5px solid #00796B;
      border-radius: 6px;
      padding: 20px;
      margin-bottom: 20px;
      background-color: #fff;
    }
    .btn-apply {
      background-color: #00796B;
      color: #fff;
    }
    .btn-apply:hover {
      background-color: #00796B;
    }
    .job-title {
      font-weight: 600;
      font-size: 1.2rem;
    }



.pagination .page-link {
    color: #00796B;
    border: 1px solid #00796B;
  }
  .pagination .page-link:hover {
    background-color: #00796B;
    color: #fff;
  }
  .pagination .active .page-link {
    background-color: #00796B;
    border-color: #00796B;
    color: #fff;
    box-shadow: none;
  }
  .border-primary{
    border-color: #00796B !important;
  }
  </style>
<div style="background-image:url('img/about-us.jpg'); background-size: cover; background-repeat: no-repeat;">
<header class="py-5 text-center" style="background-color:rgb(000, 000, 000,0.8);">
  <div class="container">
    <h1 class="text-white section-title">Select Your Desired Visa</h1>
    <p class="text-white">Explore visa options by country. Simple. Fast. Trusted by thousands globally.</p>
  </div>
</header>
</div>


<div class="container pt-5">
    <h1 class="text-center mb-4">Select Your Desired Visa</h1>

<form method="GET" class="mb-4">
  <div class="row g-2">
    <div class="col-md mt-2">
      <input type="text" name="keyword" class="form-control" placeholder="Search visa title..." value="<?= isset($_GET['keyword']) ? htmlspecialchars($_GET['keyword']) : '' ?>">
    </div>

    <div class="col-md mt-2">
      <select name="country_id" class="form-control">
        <option value="">Choose Country</option>
        <?php
        $countries = mysqli_query($conn, "SELECT id, country_name FROM countries ORDER BY country_name ASC");
        while ($row = mysqli_fetch_assoc($countries)) {
            $selected = (isset($_GET['country_id']) && $_GET['country_id'] == $row['id']) ? 'selected' : '';
            echo "<option value=\"{$row['id']}\" $selected>{$row['country_name']}</option>";
        }
        ?>
      </select>
    </div>

    <div class="col-md mt-2">
      <select name="visa_type" id="visa_type_id" class="form-control">
        <option value="">Choose Visa Type</option>
        <?php
        $visaTypes = mysqli_query($conn, "SELECT id, visa_type FROM visa_types ORDER BY visa_type ASC");
        while ($row = mysqli_fetch_assoc($visaTypes)) {
            $selected = (isset($_GET['visa_type']) && $_GET['visa_type'] == $row['id']) ? 'selected' : '';
            echo "<option value=\"{$row['id']}\" $selected>{$row['visa_type']}</option>";
        }
        ?>
      </select>
    </div>

    <div class="col-md mt-2">
      <select name="sub_visa_type" id="visa_sub_type_id" class="form-control">
        <option value="">Choose Sub Visa Type</option>
       <?php
$subOptions = "<option value=\"\">Choose Sub Visa Type</option>";

if (!empty($_GET['sub_visa_type'])) {
    $sub_id = (int)$_GET['sub_visa_type'];
    // Get sub visa name and visa_type_id (for future dynamic use)
    $subVisaQuery = mysqli_query($conn, "SELECT id, sub_visa_type, visa_type_id FROM sub_visa_types WHERE id = $sub_id");
    if ($sub = mysqli_fetch_assoc($subVisaQuery)) {
        $subOptions .= "<option value=\"{$sub['id']}\" selected>{$sub['sub_visa_type']}</option>";

        // Also load other sub types for same visa_type
        $otherSubVisas = mysqli_query($conn, "SELECT id, sub_visa_type FROM sub_visa_types WHERE visa_type_id = {$sub['visa_type_id']} AND id != $sub_id");
        while ($row = mysqli_fetch_assoc($otherSubVisas)) {
            $subOptions .= "<option value=\"{$row['id']}\">{$row['sub_visa_type']}</option>";
        }
    }
} elseif (!empty($_GET['visa_type'])) {
    // Load all sub visas under visa_type if sub_visa_type is not set
    $visa_type_id = (int)$_GET['visa_type'];
    $subVisaQuery = mysqli_query($conn, "SELECT id, sub_visa_type FROM sub_visa_types WHERE visa_type_id = $visa_type_id");
    while ($sub = mysqli_fetch_assoc($subVisaQuery)) {
        $selected = (isset($_GET['sub_visa_type']) && $_GET['sub_visa_type'] == $sub['id']) ? 'selected' : '';
        $subOptions .= "<option value=\"{$sub['id']}\" $selected>{$sub['sub_visa_type']}</option>";
    }
}

echo $subOptions;
?>

      </select>
    </div>

    <div class="col-md mt-2">
      <button type="submit" class="btn btn-primary w-100">Search</button>
    </div>

    <div class="col-md mt-2">
      <a href="visas.php" class="btn btn-danger w-100">Reset</a>
    </div>
  </div>
</form>
</div>

<section>
  <div class="container">
    <?php
    $limit = 5;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $offset = ($page - 1) * $limit;

    $keyword = isset($_GET['keyword']) ? mysqli_real_escape_string($conn, $_GET['keyword']) : '';
    $country_filter = isset($_GET['country_id']) ? (int)$_GET['country_id'] : 0;
    $visa_type_id = isset($_GET['visa_type']) ? (int)$_GET['visa_type'] : 0;
    $sub_type_id = isset($_GET['sub_visa_type']) ? (int)$_GET['sub_visa_type'] : 0;

    $country_where = '';
    if ($country_filter) {
        $country_where .= " AND c.id = $country_filter";
    }

    $total_countries_query = "SELECT COUNT(DISTINCT c.id) AS total FROM countries c WHERE 1=1 $country_where";
    $total_result = mysqli_query($conn, $total_countries_query);
    $total_row = mysqli_fetch_assoc($total_result);
    $total_countries = $total_row['total'];
    $total_pages = ceil($total_countries / $limit);

    $countries_query = "SELECT DISTINCT c.id, c.country_name FROM countries c
                        WHERE 1=1 $country_where
                        ORDER BY c.country_name ASC
                        LIMIT $offset, $limit";
    $countries_result = mysqli_query($conn, $countries_query);

    while ($country = mysqli_fetch_assoc($countries_result)) {
        echo "<h4 class=\"border-start border-3 border-primary my-color ps-3 pt-5 fw-bold\">{$country['country_name']} <i class='fa fa-long-arrow-right'></i></h4>";
        echo "<div class=\"row g-4 mt-2\">";

        $visa_where = "WHERE v.country_id = {$country['id']}";
        if ($keyword) {
            $visa_where .= " AND v.title LIKE '%$keyword%'";
        }
        if ($visa_type_id) {
            $visa_where .= " AND v.visa_type = $visa_type_id";
        }
        if ($sub_type_id) {
            $visa_where .= " AND v.sub_visa_type = $sub_type_id";
        }

        $visas_query = "SELECT v.id, v.title, v.short_detail, v.apply_link,
                               vt.visa_type AS visa_type_name,
                               sv.sub_visa_type AS sub_visa_type_name
                        FROM visas v
                        LEFT JOIN visa_types vt ON v.visa_type = vt.id
                        LEFT JOIN sub_visa_types sv ON v.sub_visa_type = sv.id
                        $visa_where
                        ORDER BY v.id DESC
                        LIMIT 3";

        $visas_result = mysqli_query($conn, $visas_query);

        if (!$visas_result) {
            echo "<p class='text-danger'>Query Error: " . mysqli_error($conn) . "</p>";
            continue;
        }

        if (mysqli_num_rows($visas_result) > 0) {
            while ($visa = mysqli_fetch_assoc($visas_result)) {
                echo "<div class=\"col-md-4 mt-3\">
                        <div class=\"card h-100 shadow-sm border-start border-4 border-primary\">
                            <div class=\"card-body\">
                                <div class='d-flex justify-content-start'><h5 class=\"card-title\">{$visa['title']}</h5> <small class='ms-2'>({$visa['visa_type_name']} - {$visa['sub_visa_type_name']})</small></div>
                                <p class=\"card-text\">{$visa['short_detail']}</p>
                                <a href=\"visa-details.php?id={$visa['id']}\" class=\"btn btn-success w-100\">Apply Now</a>
                            </div>
                        </div>
                      </div>";
            }

            echo "<div class=\"col-12 text-end\">
                    <a href=\"country-visas.php?country_id={$country['id']}&keyword=" . urlencode($keyword) . "&visa_type=$visa_type_id&sub_visa_type=$sub_type_id\" class=\"btn btn-secondary\">See More Visas</a>
                  </div>";
        } else {
            echo "<p class='text-muted ps-3'>No visas found for this country.</p>";
        }

        echo "</div>";
    }
    ?>

    <!-- Pagination -->
    <nav class="mt-4">
      <ul class="pagination justify-content-center">
        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
          <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
            <a class="page-link" href="?page=<?= $i ?>&keyword=<?= urlencode($keyword) ?>&country_id=<?= $country_filter ?>&visa_type=<?= $visa_type_id ?>&sub_visa_type=<?= $sub_type_id ?>"><?= $i ?></a>
          </li>
        <?php endfor; ?>
      </ul>
    </nav>
  </div>
</section>

<!-- JavaScript to load Sub Visa Types dynamically -->
<script>
document.getElementById('visa_type_id').addEventListener('change', function() {
    var visaTypeId = this.value;
    var subTypeDropdown = document.getElementById('visa_sub_type_id');
    subTypeDropdown.innerHTML = '<option value="">Loading...</option>';

    fetch('get_sub_visas.php?visa_type_id=' + visaTypeId)
        .then(response => response.json())
        .then(data => {
            subTypeDropdown.innerHTML = '<option value="">Choose Sub Visa Type</option>';
            data.forEach(function(sub) {
                subTypeDropdown.innerHTML += '<option value="' + sub.id + '">' + sub.sub_visa_type + '</option>';
            });
        });
});
</script>







 <?php include 'include/footer.php';?>